//**********************************************************************************************
//* WebMail Library
//* ---------------
//* A collection of internet e-mail protocol (POP, SMTP, IMAP) 
//* encapsulation classes for Ultimate++
//* 


#include "WebMail.h"


void MailSocket::Send(String s, int timeout)
{
	if(transcript && !s.IsEmpty()) {
		transcript->Cat(s);
		if(*s.Last() != '\n')
			transcript->Cat('\n');
	}
	
	dword t = SetTimeout(timeout);
	const char *p = s.Begin(), *e = s.End();
	while(p != e) {
		if(GetTickCount() > t)
			throw Exc(t_("Communication failure: Timeout."));
		int amount = socket.WriteRaw(p, int(e - p)), err;
		if(amount > 0) {
			
			// some data has been sent - reset timeout.
			p += amount;
			t = SetTimeout(timeout);
		}
		else
		if(amount == 0)
			throw Exc(t_("Error writing data to socket: Communication port closed."));
		else
		if((err = Socket::GetErrorCode()) != SOCKERR(EWOULDBLOCK)) {
			String str;
			throw Exc(str << t_("Error writing data to socket, error code: ") << err);
		}
		else
			Sleep(100);
	}
}

String MailSocket::Recv(String s, bool multiline, int timeout)
{
	String dest;

	dword t = SetTimeout(timeout);
	
	
	for(;;) {
		if(GetTickCount() > t)
			throw Exc(t_("Communication failure: Timeout"));
		char buffer[100];
		int amount = socket.ReadRaw(buffer, sizeof(buffer)), err;
		if(amount > 0) {
			dest.Cat(buffer, amount);
			if(multiline) {
			 int pos =  dest.Find("\r\n.\r\n");
			 if(pos != -1)
			 	return dest;
			}
			else {
				while(--amount >=0)
					if(buffer[amount] == '\n') {
						if(transcript && !dest.IsEmpty()) {
							transcript->Cat(dest);
							if(*dest.Last() != '\n')
								transcript->Cat('\n');
						}
						return dest;
					}
			}			
		}
		else
		if(amount == 0)
			throw Exc(t_("Error reading data from socket: Communication port closed."));
		else
		if((err = Socket::GetErrorCode()) != SOCKERR(EWOULDBLOCK)) {
			String str;
			throw Exc(str << t_("Error writing data to socket, error code: ") << err);
		}
		else
			Sleep(100);	
	}
}

void MailSocket::Connect(String host, int port, String user, String pass)
{
	host0 = host; port0 = port;
	user0 = user; pass0 = pass;
	
	String data, ipaddr = "127.0.0.1";
	dword inaddr;
	if((IsNull(host0)))
		throw Exc(t_("Error: Host not set."));
	if((IsNull(user0)))
		throw Exc(t_("Error: User not set."));
	if(ssltype == NOSSL) {
		Socket::Init();
		if(!::ClientSocket(socket, host0, port0, true, &inaddr, 1000, true))
			throw Exc(NFormat(t_("Cannot open socket %s:%d: Reason: %s"), host0, port0, Socket::GetErrorText()));
	}
	else {
//		SSLInit();
		SSLContext sslcontext;
			if(sslcontext.IsEmpty()) {
				if(!sslcontext.Create(ssltype == TLS ? TLSv1_client_method() : SSLv2_client_method())) {
					throw Exc(t_("Cannot initiate SSL context"));
				}
				sslcontext.VerifyPeer(false);
			}
		if(!::SSLClientSocket(socket,sslcontext, host0, port0, true, &inaddr, 1000, true))
			throw(Exc(NFormat(t_("Cannot open secure socket %s:%d: Reason: %s"), host0, port0, ::SSLGetLastError())));
	}
	// Host-to-network byte ordering conversion.
	ipaddr
		<< (int)((inaddr >>  0) & 0xFF) << '.'
		<< (int)((inaddr >>  8) & 0xFF) << '.'
		<< (int)((inaddr >> 16) & 0xFF) << '.'
		<< (int)((inaddr >> 24) & 0xFF);	
}